function BrowserDetect() {
   var ua = navigator.userAgent.toLowerCase();
   this.isGecko = (ua.indexOf("gecko") !=- 1 && ua.indexOf("safari") ==- 1);
   this.isAppleWebKit = (ua.indexOf("applewebkit") !=- 1);
   this.isKonqueror = (ua.indexOf("konqueror") !=- 1);
   this.isSafari = (ua.indexOf("safari") !=- 1);
   this.isOmniweb = (ua.indexOf("omniweb") !=- 1);
   this.isOpera = (ua.indexOf("opera") !=- 1);
   this.isIcab = (ua.indexOf("icab") !=- 1);
   this.isAol = (ua.indexOf("aol") !=- 1);
   this.isIE = (ua.indexOf("msie") !=- 1 &&!this.isOpera && (ua.indexOf("webtv") ==- 1));
   this.isMozilla = (this.isGecko && ua.indexOf("gecko/") + 14 == ua.length);
   this.isFirebird = (ua.indexOf("firebird/") !=- 1);
   this.isFirefox = (ua.indexOf("firefox/") !=- 1);
   this.isNS = ((this.isGecko) ? (ua.indexOf("netscape") !=- 1) : ((ua.indexOf("mozilla") !=- 1) &&!this.isOpera &&!this.isSafari && (ua.indexOf("spoofer") ==- 1) && (ua.indexOf("compatible") ==- 1) && (ua.indexOf("webtv") ==- 1) && (ua.indexOf("hotjava") ==- 1)));
}
function createCookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eraseCookie(name) {
	createCookie(name,"",-1);

}
var browser = new BrowserDetect();
var mbLeft = browser.isIE?1:0;

__controls = new Array();

function _btnHandler(sender,id) {
    
       document.getElementById(sender).control._click(id);
}

function elementWidth(e) {
  if( typeof( e.innerWidth ) == 'number' ) {
    //Non-IE
    return parseInt(e.innerWidth);
  } else if( e.clientWidth )  {
    //IE 6+ in 'standards compliant mode'
    return parseInt(e.clientWidth);
  } else 
   if (e.style.width)
    return parseInt(e.style.width);
   else 
    return 0;

}

function windowWidth() {
  var myWidth = 0;
  if( typeof( window.innerWidth ) == 'number' ) {
    //Non-IE
    myWidth = window.innerWidth;
  } else if( document.documentElement && ( document.documentElement.clientWidth ) ) {
    //IE 6+ in 'standards compliant mode'
    myWidth = document.documentElement.clientWidth;
  } else if( document.body && ( document.body.clientWidth) ) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
  }
  return myWidth;
}

function windowHeight() {
  var myWidth = 0;
  if( typeof( window.innerHeight ) == 'number' ) {
    //Non-IE
    myWidth = window.innerHeight;
  } else if( document.documentElement && ( document.documentElement.clientHeight ) ) {
    //IE 6+ in 'standards compliant mode'
    myWidth = document.documentElement.clientHeight;
  } else if( document.body && ( document.body.clientHeight ) ) {
    //IE 4 compatible
    myWidth = document.body.clientHeight;
  }
  return myWidth;
}

function fixE(e) {
 if(typeof e == "undefined") {
    e = window.event;
    }
 if(typeof e.layerX == "undefined") {
    e.layerX = e.offsetX;
    }
 if(typeof e.layerY == "undefined") {
    e.layerY = e.offsetY;
    }
 if(!e.target) {
   e.target = e.srcElement;
 }
 return e;
}

function addEvent(obj, type, fn)
{

if (obj.addEventListener){
               obj.addEventListener( type,function (e) { e = fixE(e); fn(e); } , false );
       } else if(obj.attachEvent) {
               obj.attachEvent( "on"+type,  function (e) { e = fixE(e); fn(e); } );
       } else {
               obj["on"+type] = function (e) { e = fixE(e); fn(e); };
       }
}


function Drag(obj, dragarea) {

 this.startdrag = function(e) {
  if(e.button==mbLeft) {
    try {
       document.selection.empty();
    }
    catch(ex) {
    }
   e.target.dragger.p.x = e.clientX;
   e.target.dragger.p.y = e.clientY;
   e.target.dragger.dragState = 1;
  }

 }
 this.dragmove = function(e) {
  var d = e.target.dragger;
  if(d.dragState==1) {
   if(Math.abs(e.clientX - d.p.x) > 4 || Math.abs(e.clientY - d.p.y) > 4) 
    d.dragState= 2;
  } else
  if(d.dragState == 2) {
    var dx = e.clientX - d.p.x;
    var dy = e.clientY - d.p.y;
    d.p.x = e.clientX;
    d.p.y = e.clientY;
    var x = d.obj.style.left?parseInt(d.obj.style.left):d.obj.clientLeft;
    var y = d.obj.style.top?parseInt(d.obj.style.top):d.obj.clientTop;
    d.obj.control.setX(x+dx);
    d.obj.control.setY(y+dy);
    try {
       document.selection.empty();
    }
    catch(ex) {
    }

  }
 }
 this.stopdrag = function(e) {
  e.target.dragger.dragState = 0;
 }
 this.dragState = 0;
 this.p = {x:0, y:0};
 this.obj = obj;
 if(dragarea) this.dragarea = dragarea;
 else this.dragarea = obj;
 this.dragarea.dragger = this;
 addEvent(this.dragarea,"mousedown",this.startdrag);
 addEvent(this.dragarea,"mousemove",this.dragmove);
 addEvent(this.dragarea,"mouseup",this.stopdrag);
 addEvent(this.dragarea,"mouseout",this.stopdrag);
}

function TControl (e, cfg) {
 this._init = function(e,cfg)  {
  this.element = document.getElementById(e);
  this.elementName = e;
  this.config = cfg;
  this._rendered = false;
 }

 this._render = function(owner) {
  if(owner) 
   if(document.getElementById(owner)) owner = document.getElementById(owner); 
  if(!this.element) 
   this.element = document.getElementById(this.elementName);
  if(!this.element) {
    this.element  = document.createElement('div');
    this.element.id = this.elementName;
    if(owner) owner.appendChild(this.element);
    else 
     document.body.appendChild(this.element);
  }
  if(owner && owner.style.zIndex) this.element.style.zIndex = owner.style.zIndex+1;
  __controls[this.elementName] = this;
  this.element.control = this;
  if(this.config.x || this.config.y || this.config.align)
    this.element.style.position = 'absolute';
  if(this.config.width) this.element.style.width = this.config.width;
  if(this.config.height) this.element.style.height = this.config.height;
  this._rendered = true;
  if(this.config.visible == false)
   this.element.style.display = 'none';
  else
  if(this.config.visible == true) {
   this.element.style.display = 'block';
  }

  if(this.config.x) this.element.style.left = this.config.x;
  if(this.config.y) this.element.style.top =  this.config.y;
 }

 this.show = function() {
  if(!this._rendered) this.render();
  if(this.config.align=='center') {
   this.element.style.left = (windowWidth() - elementWidth(this.element)) /2;
  }
  this.element.style.display = 'block';
  this.config.visible = true;
 }
 this.hide = function() {
  if(!this._rendered) this.render();
  this.element.style.display = 'none';
  this.config.visible = false;
 }

 this.setWidth = function (value)  {
  this.config.width = value;
  if(this._rendered) 
    this.element.style.width = value;

 }

 this.setHeight = function (value)  {
  this.config.height = value;
  if(this._rendered) 
    this.element.style.height = value;

 }

 this.setX = function(value) {
  this.config.x = value;
  if(this._rendered) {
    this.element.style.position = 'absolute';
    this.element.style.left = value;
  }
 }

 this.setY = function(value) {
  this.config.y = value;
  if(this._rendered) {
    this.element.style.position = 'absolute';
    this.element.style.top = value;
  }

 }
 
 this._init(e,cfg);
}

function Panel(e,cfg) {
 this._init(e,cfg);
 this.Hdr = -1;
 this.header = "";
 this.setBody = function(value) {
  this.body = value;
  if(this._rendered) 
    if(this.Hdr==-1)
     this.render();
    else
     document.getElementById("pBdy"+this.Hdr).innerHTML = this.body;
 }
 this.setHeader = function(value) {
  this.header = value;
  if(this._rendered) {
   if(this.Hdr==-1)
    this.render();
   else
    document.getElementById("pHdr"+this.Hdr).innerHTML = this.header;
  }
 }

 this._prepareHTML = function() {
  for(this.Hdr=1;document.getElementById("pHdr"+this.Hdr); this.Hdr++ );
  html = "<TABLE cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" height=\"100%\"><tr>"+
           "<td class=\"panel-left-top\">&nbsp;</td>"+
             "<td class=\"panel-top\" Id=\"pHdr"+this.Hdr+ "\">"+this.header+"</td>"+
           "<td class=\"panel-right-top\">";
  if(this.config.close) html +="<div CLASS=\"panel-close-button\" OnClick=\"document.getElementById('"+this.elementName+"').control.hide();\"></div>";
  else html +="&nbsp;";
  html +="</td>"+
           "</tr>"+
          "<tr>"+
          "<td class=\"panel-left\">&nbsp;</td>"+
               "<td valign=\"top\" class=\"panel-body\" id=\"pBdy"+this.Hdr+"\">"+
                 this.body+
               "</td>"+
           "<td class=\"panel-right\">&nbsp;</td>"+
           "</tr>"+

           "<tr><td class=\"panel-left-bottom\">&nbsp;</td>"+
           "<td valign=\"top\" class=\"panel-bottom\" id=\"pFtr"+this.Hdr+"\" style=\"text-align:center\">";
           if(this.footer) html+=this.footer; else html+="&nbsp;"
           html+="</td>"+
           "<td class=\"panel-right-bottom\">&nbsp;</td>"+
           "</tr></table>";
/*  if(this.config.shadow) {
     html="<div style=\"border: thin solid black;width:100%\"><div style=\"width:100%;\" class=\"panel-shadow-right\"><div style=\"width:97%;\">"+html+"</div></div><div style=\"width:100%\" class=\"panel-shadow-bottom\"></div></div>";

  } */
  return html;
 }
 this.render = function(owner) {
  this._render(owner);
  if(!this.body) 
   this.body = this.element.innerHTML;
  this.element.innerHTML = this._prepareHTML();

 }
}

Panel.prototype = new TControl();

function Dialog(e,cfg) {
 this._init(e,cfg);

 this.render = function(owner) {
  this._render(owner);
  if(this.element.parentNode != document.body) {
   var self = this;
   this.ctrlIdx = OnLoadEvents.length;
   OnLoadEvents[OnLoadEvents.length] = new function() { 
      this.event = function(s)  {
       if(s.element.parentNode)
        s.element.parentNode.removeChild(s.element);
       document.body.appendChild(s.element);
      }
      this.sender = self;
   }
  }
  if(!this.body) 
   this.body = this.element.innerHTML;
  this.element.innerHTML = this._prepareHTML().replace(/panel-/g,'dialog-');

  if(this.config.dragable) {
    var hdr = document.getElementById("pHdr"+this.Hdr);
    if(!hdr) {
     return;
    }
    hdr.style.cursor = 'move';
    this.Drag = new Drag(this.element,hdr);
  }  
 }

 this.setButtons = function(buttons) {
  var html = "";
  this.buttons = buttons;
  for(i=0;btn=buttons[i];i++) {
   html += "<input class=\"button\" type=\"button\" value=\""+btn.caption+"\" onclick=\"_btnHandler('"+this.elementName+"',"+i+")\">";
  }
  this.footer = html;
  if(this._rendered)
   document.getElementById("pFtr"+this.Hdr).innerHTML = html;
 }
 this._click = function(index) {
  this.buttons[index].handler(this);
 }
}

Dialog.prototype = new Panel();

function Carousel(e,cfg) {
 this._init(e,cfg);
 this.pages = new Array();
 this.pageIndex = -1;
 this.bodyIndex = 1;
 this.render = function(owner) {

  this._render(owner);
//  if(!this.config.prevBtn) this.config.prevBtn = "<<";
//  if(!this.config.nextBtn) this.config.nextBtn = ">>";
  for(this.bodyIndex = 1;document.getElementById("cBdy"+this.bodyIndex);this.bodyIndex++) ;
  this.element.innerHTML = "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td style=\"text-align:right;\">"+
                           "<INPUT TYPE=\"BUTTON\" VALUE=\"<<\" OnClick=\"__controls['"+this.elementName+"'].prevPage();\">"+
                           "<INPUT TYPE=\"BUTTON\" VALUE=\">>\" OnClick=\"__controls['"+this.elementName+"'].nextPage();\"></td></tr>"+
                           "<tr><td class=\"carousel-body\" id=\"cBdy"+this.bodyIndex+"\">"+this.pages[this.pageIndex]+"</td></tr></table>"; 
  this.element.control = this;
 }
 this.nextPage = function() {
  if(this.pageIndex!= this.pages.length-1) this.pageIndex++;
  else 
   if(this.config.cycle) 
    this.pageIndex = 0;
  if(this._rendered) {
    var d = document.getElementById("cBdy"+this.bodyIndex);
    d.innerHTML = this.pages[this.pageIndex];
  } 
 }
 this.prevPage = function() {
  if(this.pageIndex!=0) this.pageIndex--;
  else 
   if(this.config.cycle) 
    this.pageIndex = this.pages.length-1;
  if(this._rendered) {
    var d = document.getElementById("cBdy"+this.bodyIndex);
    d.innerHTML = this.pages[this.pageIndex];
  } 
 }

 this.addPage = function (p, makeActive) {
  this.pages.push(p.innerHTML);
  p.style.display = 'none';
  if(makeActive) 
   showPage(this.pages.length-1)
  else
  if(this.pageIndex==-1)
   this.pageIndex = 0;
 }

 this.addPageText = function (p, makeActive) {
  this.pages.push(p);
  if(makeActive) 
   showPage(this.pages.length-1)
  else
  if(this.pageIndex==-1)
   this.pageIndex = 0;
 }

 this.showPage = function(index) {
  if(index >= 0 && index < this.pages.length) {
   this.pageIndex = index;
   if(!this._rendered) this.render();
   else {
    var d = document.getElementById("cBdy"+this.bodyIndex);
    d.innerHTML = this.pages[this.pageIndex];
   }

  }
 }

 this.removePage = function(index) {

 }
 this.clearPages = function() {
  this.pages = new Array();
  this.pageIndex = -1;
 }
}

Carousel.prototype = new TControl(); 

function Calendar(e,cfg) {
 this._init(e,cfg);
}
Calendar.prototype = new TControl();

